/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.utils;

import filenet.vw.api.VWException;
import filenet.vw.base.logging.Logger;
import filenet.ws.api.WSTemplateBase;
import filenet.ws.utils.jsse.WSJSSE;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.Vector;
import javax.wsdl.WSDLException;
import org.apache.axis.Constants;
import org.apache.axis.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WSWSDLRetriever {
    protected static Logger logger = Logger.getLogger("filenet.ws.utils");
    protected static final String m_className = "WSWSDLRetriever";
    private Vector m_localFiles = null;
    private File m_localFileDir = null;
    private Hashtable m_retrievedFiles = new Hashtable();
    private Hashtable m_fileNames = new Hashtable();
    private String m_wsdlURI = null;
    private String m_filePath = null;

    public static String _get_FILE_DATE() {
        return "$Date:   10 Sep 2008 10:04:28  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.1  $";
    }

    public WSWSDLRetriever(String wsdlURI) {
        this.m_wsdlURI = wsdlURI;
    }

    public String retrieve() throws VWException, WSDLException, Exception {
        if (this.m_filePath == null) {
            this.m_localFiles = new Vector();
            String path = this.retrieveWSDL();
            this.m_filePath = new File(path).toURI().toASCIIString();
        }
        return this.m_filePath;
    }

    public void cleanup() {
        if (this.m_localFiles != null) {
            Object obj = null;
            for (int i = 0; i < this.m_localFiles.size(); ++i) {
                obj = this.m_localFiles.get(i);
                if (obj == null || !(obj instanceof File)) continue;
                ((File)obj).delete();
            }
            this.m_localFiles.clear();
            this.m_localFiles = null;
            if (this.m_localFileDir != null) {
                this.m_localFileDir.delete();
            }
            this.m_localFileDir = null;
            this.m_filePath = null;
            if (this.m_retrievedFiles != null) {
                this.m_retrievedFiles.clear();
            }
            if (this.m_fileNames != null) {
                this.m_fileNames.clear();
            }
        }
    }

    protected String retrieveWSDL() throws VWException {
        if (this.m_filePath != null) {
            return this.m_filePath;
        }
        String m_method = "retrieveWSDL: " + this.m_wsdlURI;
        String path = null;
        this.m_localFiles = new Vector();
        try {
            File dir;
            if (this.m_wsdlURI == null || this.m_wsdlURI.trim().length() == 0) {
                return null;
            }
            File fTempDir = File.createTempFile("wsrr", null);
            String sTempFile = fTempDir.getName();
            fTempDir.delete();
            String tempdir = System.getProperty("java.io.tmpdir");
            if (!tempdir.endsWith("/") && !tempdir.endsWith("\\")) {
                tempdir = tempdir + System.getProperty("file.separator");
            }
            if ((dir = new File(tempdir = tempdir + sTempFile)).exists()) {
                File[] files;
                if (dir.isDirectory() && (files = dir.listFiles()) != null) {
                    for (int i = 0; i < files.length; ++i) {
                        files[i].delete();
                    }
                }
                dir.delete();
            }
            dir.mkdirs();
            dir.deleteOnExit();
            this.m_localFileDir = dir;
            URL context = null;
            try {
                context = new URL(this.m_wsdlURI);
            }
            catch (Exception e) {
                this.m_wsdlURI = new File(this.m_wsdlURI).toURL().toString();
                context = new URL(this.m_wsdlURI);
            }
            Document doc = WSWSDLRetriever.getDocument(context);
            path = this.retrieveImportsAndIncludes(context, doc, dir, this.generateFileNameFromLocation(this.m_wsdlURI));
        }
        catch (Exception ex) {
            logger.throwing(m_className, m_method, ex);
            throw new VWException(ex);
        }
        return path;
    }

    protected String retrieveImportsAndIncludes(URL context, Document doc, File dir, String fileName) throws VWException {
        String m_method = "retrieveImportsAndIncludes";
        String path = null;
        if (doc == null || dir == null) {
            return path;
        }
        try {
            String target = null;
            try {
                Node node = null;
                for (int loop = 0; loop < 2; ++loop) {
                    target = loop == 0 ? "import" : "include";
                    NodeList nodeList = doc.getElementsByTagNameNS("*", target);
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        node = nodeList.item(i);
                        if (node == null) continue;
                        Node namespaceNode = null;
                        String namespace = null;
                        NamedNodeMap attributes = node.getAttributes();
                        if (attributes != null && (namespaceNode = attributes.getNamedItem("namespace")) != null) {
                            namespace = namespaceNode.getNodeValue();
                        }
                        if (namespace != null && WSWSDLRetriever.isKnownNamespace(namespace)) continue;
                        attributes = node.getAttributes();
                        Node fileNode = attributes.getNamedItem("schemaLocation");
                        if (fileNode == null) {
                            fileNode = attributes.getNamedItem("location");
                        }
                        if (fileNode == null) continue;
                        String location = fileNode.getNodeValue();
                        URL locationURL = WSWSDLRetriever.getURL(context, location);
                        String urlLocation = locationURL.toString();
                        String aFileName = null;
                        if (this.m_retrievedFiles.containsKey(urlLocation)) {
                            aFileName = (String)this.m_retrievedFiles.get(urlLocation);
                        } else {
                            aFileName = this.generateFileNameFromLocation(location);
                            this.m_retrievedFiles.put(urlLocation, aFileName);
                            Document aDoc = WSWSDLRetriever.getDocument(locationURL);
                            this.retrieveImportsAndIncludes(locationURL, aDoc, dir, aFileName);
                        }
                        fileNode.setNodeValue(aFileName);
                    }
                }
            }
            catch (Exception ex) {
                logger.throwing(m_className, m_method, ex);
                VWException vwex = new VWException(ex);
                throw vwex;
            }
            String strContent = WSTemplateBase.docToString(doc);
            byte[] content = strContent.getBytes();
            path = dir.getPath();
            if (!path.endsWith("/") && !path.endsWith("\\")) {
                path = path + System.getProperty("file.separator") + fileName;
            }
            File file = new File(path);
            file.deleteOnExit();
            FileOutputStream outStream = new FileOutputStream(file);
            outStream.write(content);
            outStream.flush();
            outStream.close();
            this.m_localFiles.add(file);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return path;
    }

    protected String getNameFromLocation(String location) {
        int index2;
        int index = location.lastIndexOf("\\");
        if (index != -1) {
            index += 2;
        }
        if ((index2 = location.lastIndexOf("/")) != -1) {
            ++index2;
        }
        if (index2 > index) {
            index = index2;
        }
        if (index != -1) {
            location = location.substring(index);
        }
        if ((index = location.indexOf("?")) != -1) {
            location = location.substring(0, index);
        }
        return location;
    }

    protected String generateFileNameFromLocation(String location) {
        String fileName = (String)this.m_fileNames.get(location);
        if (fileName != null) {
            return fileName;
        }
        fileName = this.getNameFromLocation(location);
        int i = 0;
        while (this.m_fileNames.contains(fileName)) {
            fileName = fileName + Integer.toString(i);
            ++i;
        }
        this.m_fileNames.put(location, fileName);
        return fileName;
    }

    protected static Document getDocument(URL url) throws Exception {
        String m_method = "getDocument:" + url;
        Document doc = null;
        String protocol = url.getProtocol().toLowerCase();
        if (protocol.compareTo("file") == 0) {
            doc = XMLUtils.newDocument((String)url.toString());
        } else {
            if (protocol.compareTo("https") == 0) {
                WSJSSE.getAutoTrustSSL();
            }
            URLConnection conn = null;
            conn = url.openConnection();
            conn.connect();
            doc = XMLUtils.newDocument((InputStream)conn.getInputStream());
        }
        return doc;
    }

    public static boolean isKnownNamespace(String namespace) {
        if (Constants.isSOAP_ENC((String)namespace)) {
            return true;
        }
        if (Constants.isSchemaXSD((String)namespace)) {
            return true;
        }
        if (Constants.isSchemaXSI((String)namespace)) {
            return true;
        }
        return namespace.equals("http://www.w3.org/XML/1998/namespace");
    }

    private static URL getURL(URL contextURL, String spec) throws IOException {
        String path = spec.replace('\\', '/');
        URL url = null;
        try {
            url = new URL(contextURL, path);
            if (contextURL != null && url.getProtocol().equals("file") && contextURL.getProtocol().equals("file")) {
                url = WSWSDLRetriever.getFileURL(contextURL, path);
            }
        }
        catch (MalformedURLException me) {
            url = WSWSDLRetriever.getFileURL(contextURL, path);
        }
        return url;
    }

    private static URL getFileURL(URL contextURL, String path) throws IOException {
        if (contextURL != null) {
            String contextFileName = contextURL.getFile();
            URL parent = null;
            File parentFile = new File(contextFileName).getParentFile();
            if (parentFile != null) {
                parent = parentFile.toURL();
            }
            if (parent != null) {
                return new URL(parent, path);
            }
        }
        return new URL("file", "", path);
    }
}

